<?php
require_once 'koneksi.php';

// Ambil data perusahaan
$profile = getCompanyProfile();
$photos = getAllPhotos();
$stats = getStats();

// Ambil 8 foto terbaru untuk galeri publik
$publicPhotos = array_slice($photos, 0, 8);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($profile['name'] ?? 'Profil Perusahaan'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#3B82F6',  // Warna biru, berbeda dari admin (ungu)
                        secondary: '#10B981',
                        accent: '#F59E0B'
                    }
                }
            }
        }
    </script>
    <style>
        .hero-pattern {
            background-image: radial-gradient(circle at 2px 2px, rgba(255,255,255,0.15) 1px, transparent 0);
            background-size: 40px 40px;
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        .floating {
            animation: floating 3s ease-in-out infinite;
        }

        @keyframes floating {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }

        .fade-in-up {
            animation: fadeInUp 0.8s ease-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .photo-gallery {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
        }

        .photo-item {
            position: relative;
            aspect-ratio: 16/9;
            border-radius: 1rem;
            overflow: hidden;
            cursor: pointer;
        }

        .gradient-text {
            background: linear-gradient(135deg, #3B82F6, #10B981);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-blue-50 via-white to-green-50 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 min-h-screen">

    <!-- Floating Navigation -->
    <nav class="fixed top-4 left-1/2 transform -translate-x-1/2 z-50 bg-white/80 dark:bg-gray-800/80 backdrop-blur-lg rounded-full px-6 py-3 shadow-lg border border-white/20">
        <div class="flex items-center space-x-6">
            <a href="#home" class="nav-link text-primary font-semibold">
                <i class="fas fa-home mr-1"></i>
                Beranda
            </a>
            <a href="#about" class="nav-link text-gray-600 dark:text-gray-300 hover:text-primary transition-colors">
                Tentang
            </a>
            <a href="#gallery" class="nav-link text-gray-600 dark:text-gray-300 hover:text-primary transition-colors">
                Galeri
            </a>
            <a href="#contact" class="nav-link text-gray-600 dark:text-gray-300 hover:text-primary transition-colors">
                Kontak
            </a>
            <a href="login.php" class="bg-primary text-white px-4 py-2 rounded-full hover:bg-blue-600 transition-colors text-sm">
                <i class="fas fa-sign-in-alt mr-1"></i>
                Login
            </a>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="home" class="relative min-h-screen flex items-center justify-center hero-pattern">
        <div class="absolute inset-0 bg-gradient-to-br from-primary/10 to-secondary/10"></div>
        
        <div class="relative z-10 text-center px-4 max-w-6xl mx-auto">
            <!-- Company Logo -->
            <div class="floating mb-8">
                <div class="mx-auto h-32 w-32 bg-gradient-to-br from-primary to-secondary rounded-full flex items-center justify-center shadow-2xl">
                    <i class="fas fa-building text-5xl text-white"></i>
                </div>
            </div>

            <!-- Main Title -->
            <h1 class="text-6xl md:text-7xl font-bold mb-6 fade-in-up">
                <span class="gradient-text"><?php echo htmlspecialchars($profile['name'] ?? 'Perusahaan'); ?></span>
            </h1>

            <!-- Description -->
            <p class="text-xl md:text-2xl text-gray-600 dark:text-gray-300 mb-8 max-w-4xl mx-auto leading-relaxed fade-in-up">
                <?php echo htmlspecialchars($profile['description'] ?? ''); ?>
            </p>

            <!-- Stats Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12 fade-in-up">
                <div class="card-hover bg-white/70 dark:bg-gray-800/70 backdrop-blur-lg rounded-2xl p-6 border border-white/20">
                    <div class="text-4xl font-bold text-primary mb-2"><?php echo $stats['total_photos']; ?></div>
                    <div class="text-gray-600 dark:text-gray-400">Foto Dokumentasi</div>
                    <i class="fas fa-images text-primary/30 text-3xl mt-2"></i>
                </div>
                
                <div class="card-hover bg-white/70 dark:bg-gray-800/70 backdrop-blur-lg rounded-2xl p-6 border border-white/20">
                    <div class="text-4xl font-bold text-secondary mb-2"><?php echo $stats['founded_year']; ?></div>
                    <div class="text-gray-600 dark:text-gray-400">Tahun Berdiri</div>
                    <i class="fas fa-calendar-alt text-secondary/30 text-3xl mt-2"></i>
                </div>
                
                <div class="card-hover bg-white/70 dark:bg-gray-800/70 backdrop-blur-lg rounded-2xl p-6 border border-white/20">
                    <div class="text-4xl font-bold text-accent mb-2"><?php echo $stats['total_employees']; ?></div>
                    <div class="text-gray-600 dark:text-gray-400">Pengurus/guru</div>
                    <i class="fas fa-users text-accent/30 text-3xl mt-2"></i>
                </div>
            </div>

            <!-- CTA Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center fade-in-up">
                <a href="#about" class="bg-primary text-white px-8 py-4 rounded-full hover:bg-blue-600 transition-all duration-300 transform hover:scale-105 shadow-lg">
                    <i class="fas fa-arrow-down mr-2"></i>
                    Pelajari Lebih Lanjut
                </a>

            </div>
        </div>

        <!-- Scroll Indicator -->
        <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce">
            <i class="fas fa-chevron-down text-primary text-2xl"></i>
        </div>
    </section>

    <!-- About Section -->
    <section id="about" class="py-20 bg-white/50 dark:bg-gray-800/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold gradient-text mb-6">Tentang Kami</h2>
                <div class="w-24 h-1 bg-gradient-to-r from-primary to-secondary mx-auto rounded-full"></div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
                <!-- Content -->
                <div class="space-y-8">
                    <div class="card-hover bg-white/80 dark:bg-gray-800/80 backdrop-blur-lg rounded-2xl p-8 border border-white/20">
                        <div class="flex items-center mb-4">
                            <div class="h-12 w-12 bg-primary/10 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-eye text-primary text-xl"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Visi Kami</h3>
                        </div>
                        <p class="text-gray-600 dark:text-gray-400 leading-relaxed">
                            <?php echo nl2br(htmlspecialchars($profile['vision'] ?? '')); ?>
                        </p>
                    </div>

                    <div class="card-hover bg-white/80 dark:bg-gray-800/80 backdrop-blur-lg rounded-2xl p-8 border border-white/20">
                        <div class="flex items-center mb-4">
                            <div class="h-12 w-12 bg-secondary/10 rounded-lg flex items-center justify-center mr-4">
                                <i class="fas fa-target text-secondary text-xl"></i>
                            </div>
                            <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Misi Kami</h3>
                        </div>
                        <p class="text-gray-600 dark:text-gray-400 leading-relaxed">
                            <?php echo nl2br(htmlspecialchars($profile['mission'] ?? '')); ?>
                        </p>
                    </div>
                </div>

                <!-- Info Card -->
                <div class="card-hover bg-gradient-to-br from-primary to-secondary rounded-3xl p-8 text-white shadow-2xl">
                    <h3 class="text-3xl font-bold mb-8 text-center">Hubungi Kami</h3>
                    
                    <div class="space-y-6">
                        <div class="flex items-center bg-white/10 rounded-xl p-4">
                            <i class="fas fa-envelope text-2xl mr-4"></i>
                            <div>
                                <div class="font-semibold">Email</div>
                                <div class="opacity-90"><?php echo htmlspecialchars($profile['email'] ?? ''); ?></div>
                            </div>
                        </div>
                        
                        <div class="flex items-center bg-white/10 rounded-xl p-4">
                            <i class="fas fa-phone text-2xl mr-4"></i>
                            <div>
                                <div class="font-semibold">Telepon</div>
                                <div class="opacity-90"><?php echo htmlspecialchars($profile['phone'] ?? ''); ?></div>
                            </div>
                        </div>
                        
                        <div class="flex items-center bg-white/10 rounded-xl p-4">
                            <i class="fas fa-globe text-2xl mr-4"></i>
                            <div>
                                <div class="font-semibold">Website</div>
                                <div class="opacity-90"><?php echo htmlspecialchars($profile['website'] ?? ''); ?></div>
                            </div>
                        </div>
                        
                        <div class="flex items-start bg-white/10 rounded-xl p-4">
                            <i class="fas fa-map-marker-alt text-2xl mr-4 mt-1"></i>
                            <div>
                                <div class="font-semibold">Alamat</div>
                                <div class="opacity-90"><?php echo nl2br(htmlspecialchars($profile['address'] ?? '')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Gallery Section -->
    <section id="gallery" class="py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl md:text-5xl font-bold gradient-text mb-6">Galeri Dokumentasi</h2>
                <p class="text-xl text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">
                    Lihat Aktivitas Ponpes Melalui Dokumentasi Foto
                </p>
                <div class="w-24 h-1 bg-gradient-to-r from-primary to-secondary mx-auto rounded-full mt-6"></div>
            </div>

            <?php if (empty($publicPhotos)): ?>
            <div class="text-center py-16">
                <div class="h-24 w-24 bg-gray-100 dark:bg-gray-800 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-images text-4xl text-gray-400"></i>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-4">Galeri Segera Hadir</h3>
                <p class="text-gray-600 dark:text-gray-400">Dokumentasi foto akan ditampilkan di sini</p>
            </div>
            <?php else: ?>
            
            <!-- Category Filter -->
            <div class="flex flex-wrap justify-center gap-3 mb-12">
                <button class="filter-btn active px-6 py-3 rounded-full bg-primary text-white font-medium transition-all duration-300" data-category="all">
                    Semua Foto
                </button>
                <button class="filter-btn px-6 py-3 rounded-full bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-300 hover:bg-primary hover:text-white transition-all duration-300" data-category="office">
                    Kantor
                </button>
                <button class="filter-btn px-6 py-3 rounded-full bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-300 hover:bg-primary hover:text-white transition-all duration-300" data-category="team">
                    Pengurus
                </button>
                <button class="filter-btn px-6 py-3 rounded-full bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-300 hover:bg-primary hover:text-white transition-all duration-300" data-category="event">
                    Acara
                </button>
            </div>

            <!-- Photo Grid -->
            <div class="photo-gallery">
                <?php foreach ($publicPhotos as $photo): ?>
                <div class="photo-item card-hover bg-white dark:bg-gray-800 shadow-lg" 
                     data-category="<?php echo htmlspecialchars($photo['category']); ?>"
                     onclick="openPhotoModal('<?php echo htmlspecialchars($photo['url']); ?>', '<?php echo htmlspecialchars($photo['caption']); ?>')">
                    
                    <img src="<?php echo htmlspecialchars($photo['url']); ?>" 
                         alt="<?php echo htmlspecialchars($photo['caption']); ?>" 
                         class="w-full h-full object-cover"
                         loading="lazy">
                    
                    <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-transparent to-transparent opacity-0 hover:opacity-100 transition-all duration-300">
                        <div class="absolute bottom-0 left-0 right-0 p-6">
                            <h4 class="text-white font-bold text-lg mb-2"><?php echo htmlspecialchars($photo['caption']); ?></h4>
                            <div class="flex items-center justify-between">
                                <span class="bg-white/20 text-white px-3 py-1 rounded-full text-sm">
                                    <?php echo ucfirst(htmlspecialchars($photo['category'])); ?>
                                </span>
                                <i class="fas fa-expand text-white text-lg"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <!-- Load More Button -->
            <?php if (count($photos) > 8): ?>
            <div class="text-center mt-12">
                <a href="login.php" class="inline-flex items-center bg-gradient-to-r from-primary to-secondary text-white px-8 py-4 rounded-full hover:shadow-lg transition-all duration-300 transform hover:scale-105">
                    <i class="fas fa-images mr-2"></i>
                    Lihat Semua Foto (<?php echo count($photos); ?> total)
                </a>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-2">Login untuk mengakses galeri lengkap</p>
            </div>
            <?php endif; ?>
            
            <?php endif; ?>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-4xl md:text-5xl font-bold gradient-text mb-6">Mari beraktivitas</h2>
            <p class="text-xl text-gray-600 dark:text-gray-400 mb-12">
                Tertarik untuk mengetahui lebih banya dari ponpes kami?
            </p>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-12">
                <a href="mailto:<?php echo htmlspecialchars($profile['email'] ?? ''); ?>" 
                   class="card-hover bg-white dark:bg-gray-800 p-8 rounded-2xl border border-white/20 group">
                    <div class="h-16 w-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-primary group-hover:text-white transition-all duration-300">
                        <i class="fas fa-envelope text-2xl text-primary group-hover:text-white"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Email Kami</h3>
                    <p class="text-gray-600 dark:text-gray-400">Kirim pesan langsung ke email ponpes</p>
                </a>

                <a href="tel:<?php echo htmlspecialchars($profile['phone'] ?? ''); ?>" 
                   class="card-hover bg-white dark:bg-gray-800 p-8 rounded-2xl border border-white/20 group">
                    <div class="h-16 w-16 bg-secondary/10 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-secondary group-hover:text-white transition-all duration-300">
                        <i class="fas fa-phone text-2xl text-secondary group-hover:text-white"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Telepon</h3>
                    <p class="text-gray-600 dark:text-gray-400">Hubungi kami langsung via telepon</p>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <div class="flex justify-center items-center mb-6">
                <div class="h-16 w-16 bg-gradient-to-br from-primary to-secondary rounded-full flex items-center justify-center mr-4">
                    <i class="fas fa-building text-white text-2xl"></i>
                </div>
                <h3 class="text-3xl font-bold"><?php echo htmlspecialchars($profile['name'] ?? ''); ?></h3>
            </div>
            
            <p class="text-gray-400 mb-8 max-w-2xl mx-auto">
                <?php echo htmlspecialchars($profile['description'] ?? ''); ?>
            </p>
            
            <div class="border-t border-gray-800 pt-8">
                <p class="text-gray-400">
                    &copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($profile['name'] ?? ''); ?>. All rights reserved.
                </p>
                <div class="flex justify-center space-x-6 mt-4">
                    <a href="login.php" class="text-gray-400 hover:text-primary transition-colors">
                        <i class="fas fa-sign-in-alt mr-1"></i>
                        Admin Login
                    </a>
                    <span class="text-gray-600">|</span>
                    <a href="#home" class="text-gray-400 hover:text-primary transition-colors">
                        <i class="fas fa-arrow-up mr-1"></i>
                        Kembali ke Atas
                    </a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Photo Modal -->
    <div id="photoModal" class="hidden fixed inset-0 bg-black/90 flex items-center justify-center z-50 p-4">
        <div class="relative max-w-5xl max-h-full">
            <button onclick="closePhotoModal()" class="absolute -top-12 right-0 text-white hover:text-gray-300 text-3xl z-10">
                <i class="fas fa-times"></i>
            </button>
            <img id="modalImage" class="max-w-full max-h-full object-contain rounded-lg shadow-2xl" alt="Photo">
            <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/80 to-transparent p-6 rounded-b-lg">
                <h3 id="modalCaption" class="text-white text-xl font-bold text-center"></h3>
            </div>
        </div>
    </div>

    <script>
        // Dark mode support
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }

        // Smooth scrolling for navigation
        document.querySelectorAll('.nav-link').forEach(link => {
            link.addEventListener('click', function(e) {
                if (this.getAttribute('href').startsWith('#')) {
                    e.preventDefault();
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }
                }
            });
        });

        // Update navigation active state on scroll
        window.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section[id]');
            const navLinks = document.querySelectorAll('.nav-link');
            
            let current = '';
            sections.forEach(section => {
                const sectionTop = section.offsetTop - 100;
                if (scrollY >= sectionTop) {
                    current = section.getAttribute('id');
                }
            });

            navLinks.forEach(link => {
                link.classList.remove('text-primary', 'font-semibold');
                link.classList.add('text-gray-600', 'dark:text-gray-300');
                
                if (link.getAttribute('href') === '#' + current) {
                    link.classList.add('text-primary', 'font-semibold');
                    link.classList.remove('text-gray-600', 'dark:text-gray-300');
                }
            });
        });

        // Photo gallery filter
        document.querySelectorAll('.filter-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const category = this.dataset.category;
                
                // Update active button
                document.querySelectorAll('.filter-btn').forEach(b => {
                    b.classList.remove('bg-primary', 'text-white');
                    b.classList.add('bg-white', 'dark:bg-gray-800', 'text-gray-700', 'dark:text-gray-300');
                });
                this.classList.add('bg-primary', 'text-white');
                this.classList.remove('bg-white', 'dark:bg-gray-800', 'text-gray-700', 'dark:text-gray-300');
                
                // Filter photos
                const photos = document.querySelectorAll('.photo-item');
                photos.forEach(photo => {
                    if (category === 'all' || photo.dataset.category === category) {
                        photo.style.display = 'block';
                    } else {
                        photo.style.display = 'none';
                    }
                });
            });
        });

        // Photo modal functions
        function openPhotoModal(url, caption) {
            document.getElementById('modalImage').src = url;
            document.getElementById('modalCaption').textContent = caption;
            document.getElementById('photoModal').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
        }

        function closePhotoModal() {
            document.getElementById('photoModal').classList.add('hidden');
            document.body.style.overflow = 'auto';
        }

        // Close modal with ESC key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closePhotoModal();
            }
        });

        // Close modal when clicking outside image
        document.getElementById('photoModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closePhotoModal();
            }
        });

        // Intersection Observer for fade-in animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe elements for animation
        document.querySelectorAll('.card-hover').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(30px)';
            el.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
            observer.observe(el);
        });
    </script>
</body>
</html>