<?php
// Start session untuk mengakses data session
session_start();

// Simpan username untuk pesan logout (opsional)
$username = isset($_SESSION['user']['username']) ? $_SESSION['user']['username'] : '';

// Unset semua variabel session
$_SESSION = array();

// Hapus session cookie jika ada
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Hancurkan session
session_destroy();

// Regenerate session ID untuk keamanan
session_start();
session_regenerate_id(true);

// Set pesan logout berhasil
$_SESSION['logout_message'] = $username ? "User $username berhasil logout" : "Logout berhasil";

// Redirect ke login dengan pesan
header("Location: login.php?logout=success");
exit();
?>