<?php
require_once 'koneksi.php';

// Cek jika sudah login
if (isset($_SESSION['user'])) {
    header('Location: dashboard.php');
    exit();
}

$error_message = '';
$success_message = '';

// Cek pesan logout
if (isset($_GET['logout']) && $_GET['logout'] === 'success') {
    $success_message = isset($_SESSION['logout_message']) ? $_SESSION['logout_message'] : 'Logout berhasil';
    unset($_SESSION['logout_message']); // Hapus pesan setelah ditampilkan
}

// Proses login
if ($_POST) {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error_message = 'Username dan password harus diisi';
    } else {
        $user = authenticateUser($username, $password);
        
        if ($user) {
            // Regenerate session ID untuk keamanan
            session_regenerate_id(true);
            
            $_SESSION['user'] = [
                'id' => $user['id'],
                'username' => $user['username'],
                'role' => $user['role'],
                'login_time' => date('Y-m-d H:i:s')
            ];
            
            header('Location: dashboard.php');
            exit();
        } else {
            $error_message = 'Username atau password tidak valid';
        }
    }
}
?>

<!-- Success Message (untuk logout) -->
<?php if ($success_message): ?>
<div class="bg-green-50 dark:bg-green-900/30 border border-green-200 dark:border-green-800 text-green-600 dark:text-green-300 px-4 py-3 rounded-xl mb-4">
    <i class="fas fa-check-circle mr-2"></i>
    <?php echo htmlspecialchars($success_message); ?>
</div>
<?php endif; ?>

<!-- Error Message -->
<?php if ($error_message): ?>
<div class="bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-800 text-red-600 dark:text-red-300 px-4 py-3 rounded-xl">
    <i class="fas fa-exclamation-triangle mr-2"></i>
    <?php echo htmlspecialchars($error_message); ?>
</div>
<?php endif; ?>

<?php
require_once 'koneksi.php';

// Cek jika sudah login
if (isset($_SESSION['user'])) {
    header('Location: dashboard.php');
    exit();
}

$error_message = '';

// Proses login
if ($_POST) {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error_message = 'Username dan password harus diisi';
    } else {
        $user = authenticateUser($username, $password);
        
        if ($user) {
            $_SESSION['user'] = [
                'id' => $user['id'],
                'username' => $user['username'],
                'role' => $user['role'],
                'login_time' => date('Y-m-d H:i:s')
            ];
            
            header('Location: dashboard.php');
            exit();
        } else {
            $error_message = 'Username atau password tidak valid';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistem Profil Ponpes</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#5D5CDE',
                        dark: '#181818'
                    }
                }
            }
        }
    </script>
    <style>
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .login-card {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }

        @media (prefers-color-scheme: dark) {
            .login-card {
                background: rgba(31, 41, 55, 0.95);
            }
        }
    </style>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-gray-900 dark:to-gray-800 min-h-screen">
    <!-- Background Pattern -->
    <div class="absolute inset-0 opacity-10">
        <div class="absolute inset-0" style="background-image: radial-gradient(circle at 1px 1px, rgba(255,255,255,0.15) 1px, transparent 0); background-size: 20px 20px;"></div>
    </div>

    <!-- Login Container -->
    <div class="relative min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8 fade-in">
            <!-- Header -->
            <div class="text-center">
                <div class="mx-auto h-20 w-20 bg-gradient-to-br from-primary to-purple-600 rounded-full flex items-center justify-center mb-6 shadow-lg">
                    <i class="fas fa-building text-3xl text-white"></i>
                </div>
                <h2 class="text-4xl font-bold text-gray-900 dark:text-white mb-2">
                    Selamat Datang
                </h2>
                <p class="text-lg text-gray-600 dark:text-gray-400">
                    Sistem Manajemen Profil Ponpes
                </p>
            </div>
            
            <!-- Login Form -->
            <div class="login-card rounded-2xl shadow-2xl p-8 border border-white/20">
                <form method="POST" class="space-y-6">
                    <div>
                        <label for="username" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            <i class="fas fa-user mr-2"></i>
                            Username
                        </label>
                        <input 
                            id="username" 
                            name="username" 
                            type="text" 
                            required 
                            value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                            class="block w-full px-4 py-3 text-base border border-gray-300 dark:border-gray-600 rounded-xl shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-all duration-200"
                            placeholder="Masukkan username Anda"
                            autocomplete="username"
                        >
                    </div>
                    
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            <i class="fas fa-lock mr-2"></i>
                            Password
                        </label>
                        <div class="relative">
                            <input 
                                id="password" 
                                name="password" 
                                type="password" 
                                required 
                                class="block w-full px-4 py-3 text-base border border-gray-300 dark:border-gray-600 rounded-xl shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-all duration-200"
                                placeholder="Masukkan password Anda"
                                autocomplete="current-password"
                            >
                            <button 
                                type="button" 
                                id="togglePassword"
                                class="absolute inset-y-0 right-0 pr-3 flex items-center text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
                            >
                                <i class="fas fa-eye" id="eyeIcon"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Error Message -->
                    <?php if ($error_message): ?>
                    <div class="bg-red-50 dark:bg-red-900/30 border border-red-200 dark:border-red-800 text-red-600 dark:text-red-300 px-4 py-3 rounded-xl">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        <?php echo htmlspecialchars($error_message); ?>
                    </div>
                    <?php endif; ?>

                    <!-- Submit Button -->
                    <button 
                        type="submit" 
                        class="w-full flex justify-center items-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-base font-medium text-white bg-gradient-to-r from-primary to-purple-600 hover:from-primary/90 hover:to-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary transition-all duration-200 transform hover:scale-105"
                    >
                        <i class="fas fa-sign-in-alt mr-2"></i>
                        Masuk ke Dashboard
                    </button>
                    
<!-- Tambahkan di bagian bawah login.php -->
<div class="text-center mt-6">
    <a href="visitor.php" class="text-sm text-gray-500 dark:text-gray-400 hover:text-primary transition-colors">
        <i class="fas fa-arrow-left mr-1"></i>
        Lihat sebagai Pengunjung
    </a>
</div>

                </form>
            </div>

            <!-- Footer -->
            <div class="text-center">
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    &copy; 2025 PONPES. AL-MANSHURI
                </p>
            </div>
        </div>
    </div>

    <script>
        // Dark mode support
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', event => {
            if (event.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });

        // Toggle password visibility
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eyeIcon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.classList.remove('fa-eye');
                eyeIcon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                eyeIcon.classList.remove('fa-eye-slash');
                eyeIcon.classList.add('fa-eye');
            }
        });
    </script>
</body>
</html>