<?php
// Konfigurasi database
$host = 'localhost';
$dbname = 'profil';
$username = 'root';  // Sesuaikan dengan username MySQL Anda
$password = '';      // Sesuaikan dengan password MySQL Anda

try {
    // Membuat koneksi PDO
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    
    // Set error mode ke exception
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Set default fetch mode
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    
} catch(PDOException $e) {
    die("Koneksi database gagal: " . $e->getMessage());
}

// Fungsi untuk autentikasi user
function authenticateUser($username, $password) {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND password = SHA2(?, 256)");
        $stmt->execute([$username, $password]);
        return $stmt->fetch();
    } catch(PDOException $e) {
        return false;
    }
}

// Fungsi untuk mendapatkan profil perusahaan
function getCompanyProfile() {
    global $pdo;
    
    try {
        $stmt = $pdo->query("SELECT * FROM company_profile LIMIT 1");
        return $stmt->fetch();
    } catch(PDOException $e) {
        return false;
    }
}

// Fungsi untuk update profil perusahaan
function updateCompanyProfile($data) {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("
            UPDATE company_profile SET 
            name = ?, description = ?, vision = ?, mission = ?, 
            address = ?, phone = ?, email = ?, website = ?, 
            founded = ?, employees = ?
            WHERE id = 1
        ");
        
        $result = $stmt->execute([
            $data['name'], $data['description'], $data['vision'], $data['mission'],
            $data['address'], $data['phone'], $data['email'], $data['website'],
            $data['founded'], $data['employees']
        ]);
        
        return ['success' => $result, 'message' => $result ? 'Profil berhasil diperbarui' : 'Gagal memperbarui profil'];
    } catch(PDOException $e) {
        return ['success' => false, 'message' => 'Error: ' . $e->getMessage()];
    }
}

// Fungsi untuk mendapatkan semua foto
function getAllPhotos() {
    global $pdo;
    
    try {
        $stmt = $pdo->query("SELECT * FROM photos ORDER BY created_at DESC");
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        return [];
    }
}

// Fungsi untuk menambah foto
function addPhoto($url, $caption, $category = 'general') {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("INSERT INTO photos (url, caption, category) VALUES (?, ?, ?)");
        $result = $stmt->execute([$url, $caption, $category]);
        
        if ($result) {
            $photoId = $pdo->lastInsertId();
            return [
                'success' => true, 
                'message' => 'Foto berhasil ditambahkan',
                'photo' => [
                    'id' => $photoId,
                    'url' => $url,
                    'caption' => $caption,
                    'category' => $category
                ]
            ];
        }
        return ['success' => false, 'message' => 'Gagal menambah foto'];
    } catch(PDOException $e) {
        return ['success' => false, 'message' => 'Error: ' . $e->getMessage()];
    }
}

// Fungsi untuk menghapus foto
function deletePhoto($photoId) {
    global $pdo;
    
    try {
        $stmt = $pdo->prepare("DELETE FROM photos WHERE id = ?");
        $result = $stmt->execute([$photoId]);
        
        return ['success' => $result, 'message' => $result ? 'Foto berhasil dihapus' : 'Foto tidak ditemukan'];
    } catch(PDOException $e) {
        return ['success' => false, 'message' => 'Error: ' . $e->getMessage()];
    }
}

// Fungsi untuk menghitung statistik
function getStats() {
    global $pdo;
    
    try {
        $photoCount = $pdo->query("SELECT COUNT(*) as total FROM photos")->fetch()['total'];
        $profile = getCompanyProfile();
        
        return [
            'total_photos' => $photoCount,
            'founded_year' => $profile['founded'] ?? '2010',
            'total_employees' => $profile['employees'] ?? '500+'
        ];
    } catch(PDOException $e) {
        return [
            'total_photos' => 0,
            'founded_year' => '2010',
            'total_employees' => '500+'
        ];
    }
}

// Fungsi untuk cek koneksi database
function checkConnection() {
    global $pdo;
    
    try {
        $pdo->query("SELECT 1");
        return true;
    } catch(PDOException $e) {
        return false;
    }
}

// Fungsi untuk upload foto
function uploadPhoto($file, $caption, $category = 'general') {
    global $pdo;
    
    // Validasi file
    if (!isset($file['tmp_name']) || $file['error'] !== UPLOAD_ERR_OK) {
        return ['success' => false, 'message' => 'File upload gagal'];
    }
    
    // Validasi tipe file
    $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp'];
    $fileType = $file['type'];
    
    if (!in_array($fileType, $allowedTypes)) {
        return ['success' => false, 'message' => 'Tipe file tidak didukung. Gunakan JPG, PNG, GIF, atau WebP'];
    }
    
    // Validasi ukuran file (max 5MB)
    if ($file['size'] > 5 * 1024 * 1024) {
        return ['success' => false, 'message' => 'Ukuran file terlalu besar. Maksimal 5MB'];
    }
    
    // Buat nama file unik
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $fileName = 'photo_' . time() . '_' . uniqid() . '.' . $extension;
    
    // Path untuk menyimpan file
    $uploadDir = 'uploads/photos/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    
    $uploadPath = $uploadDir . $fileName;
    
    // Upload file
    if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
        // Simpan ke database
        try {
            $stmt = $pdo->prepare("INSERT INTO photos (url, caption, category) VALUES (?, ?, ?)");
            $result = $stmt->execute([$uploadPath, $caption, $category]);
            
            if ($result) {
                $photoId = $pdo->lastInsertId();
                return [
                    'success' => true, 
                    'message' => 'Foto berhasil diupload',
                    'photo' => [
                        'id' => $photoId,
                        'url' => $uploadPath,
                        'caption' => $caption,
                        'category' => $category
                    ]
                ];
            }
        } catch(PDOException $e) {
            // Hapus file jika gagal simpan ke database
            unlink($uploadPath);
            return ['success' => false, 'message' => 'Error database: ' . $e->getMessage()];
        }
    }
    
    return ['success' => false, 'message' => 'Gagal upload file'];
}

// Fungsi untuk hapus foto (update untuk hapus file juga)
function deletePhotoWithFile($photoId) {
    global $pdo;
    
    try {
        // Ambil data foto untuk mendapatkan path file
        $stmt = $pdo->prepare("SELECT url FROM photos WHERE id = ?");
        $stmt->execute([$photoId]);
        $photo = $stmt->fetch();
        
        if ($photo) {
            // Hapus dari database
            $stmt = $pdo->prepare("DELETE FROM photos WHERE id = ?");
            $result = $stmt->execute([$photoId]);
            
            if ($result) {
                // Hapus file jika bukan URL eksternal
                if ($photo['url'] && !filter_var($photo['url'], FILTER_VALIDATE_URL) && file_exists($photo['url'])) {
                    unlink($photo['url']);
                }
                return ['success' => true, 'message' => 'Foto berhasil dihapus'];
            }
        }
        
        return ['success' => false, 'message' => 'Foto tidak ditemukan'];
    } catch(PDOException $e) {
        return ['success' => false, 'message' => 'Error: ' . $e->getMessage()];
    }
}

// Start session untuk autentikasi
session_start();
?>